%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Function name: plot_par_corr_n2o
%
% Scope:    plot overview figure drift correction (concentrations)
%
% Input:    data (structure),
%           bindata (structure),
%           binref (structure),
%           list of gas names (cell),
%           index of "target" variables that are being corrected (double),
%           anchor dataset name (string),
%           index of anchor gas (double)
%           index of anchor gas intervals (double)
%           plot title (string)
%
% Output:   overview figure drift correction (concentrations)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function plot_drift_corr_conc(data,bindata,binref,gasnames,target_idx,anchor_gas,ind_gas,ind_plateau_gas,titlename)

 if width(target_idx) <=2
    nn=2; end
 if width(target_idx) ==3
    nn=3; end
  if width(target_idx) >=4
    nn=4; end

figure;
for z=1:width(target_idx)
  
    subplot(nn,2,2*z-1);
    hold on;
    for i=1:width(gasnames)
    scatter(bindata.(gasnames{1,i})(:,1),bindata.(gasnames{1,i})(:,target_idx(1,z)),10);
    end
    errorbar(binref.mean(:,1),binref.mean(:,target_idx(1,z)),binref.std(:,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 data.all(end,1)-bindata.start_time]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    if z==1
        lll=cell(1,width(gasnames));
        for n=1:width(gasnames)
            lll{n} = string(gasnames{1,n}); end
        legend(lll,'location','northeast');
        title({sprintf('%s',titlename)}); 
    end
   
    subplot(nn,2,2*z);
    scatter(bindata.(gasnames{1,ind_gas})(:,1),bindata.(gasnames{1,ind_gas})(:,target_idx(1,z)),10);
    hold on;
    for k=1:height(data.boundaries_idx)
        xline(data.all(data.boundaries_idx(k,1),1),'--k');
    end
    yline(binref.(gasnames{1,ind_gas})(1,target_idx(1,z)),'--k');
    errorbar(binref.mean(ind_plateau_gas,1),binref.mean(ind_plateau_gas,target_idx(1,z)),binref.std(ind_plateau_gas,target_idx(1,z)),'marker','o','linestyle','none','color','k','markeredgecolor','k','markerfacecolor','none','linewidth',1.2);
    grid on;
    box on;
    xlim([0 bindata.(gasnames{1,ind_gas})(end,1)]);
    xlabel('Time [h]','fontsize',12);
    ylabel({sprintf('%s',bindata.varlabels{1,target_idx(1,z)})},'fontsize',12);
    legend(sprintf('%s',anchor_gas),'location','northeast','fontsize',10);
end

    x0 = 10;
    y0 = 50;
    ww = 900;
    hh = 700;
    set(gcf,'units','points','position',[x0,y0,ww,hh]);
    set(gcf,'Units','Inches');
    pos = get(gcf,'Position');
    set(gcf,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3),pos(4)]);

end

